/***************************************************************** 
 * FILE        : DMAMUX.h
 * 
 * DESCRIPTION : This is the header file describing the register
 *               set for:
 *               FARADAY
 *
 *               Please enter any bugs on GFORGE:
 * 				 http://gforge.freescale.net/projects/faraday-header/
 *				 Ensure you are logged in to enter bugs (top right of screen  use OneIT pass).
 *				 Tracker -> Bugs -> Submit New
 *				 Only the title (including the header name e.g. ADC.h) and description are 
 * 			 	 required  the rest can be left as default. 
 *				
 *               Alternatively send bugs to b06321@freescale.com
 *               using [FARADAY_HEADER] in subject      
 * 
 * COPYRIGHT   :(c) 2011, Freescale Semiconductor
 * 
 * VERSION     : 0
 * DATE        : 07 September 2011
 * AUTHOR      : b06321 
 * HISTORY     : 
 * v0: 	Alpha release made up from currently available BG. Not yet  
 * 		fully tested. Regs and bits are liable to change up until
 * 		tape-out.
 * 
 *
 ******************************************************************/
 
 
 
 /* ================================================================================
   ==============================       DMAMUX       ==============================  
   ================================================================================ */
#ifndef DMAMUX_H
#define DMAMUX_H
#include "typedefs.h"

/* DMAMUX - Peripheral register structure */
typedef struct DMAMUX_MemMap {
  vuint8_t CHCFG0;          /* offset: 0x00000000*/
  vuint8_t CHCFG1;          /* offset: 0x00000001*/
  vuint8_t CHCFG2;          /* offset: 0x00000002*/
  vuint8_t CHCFG3;          /* offset: 0x00000003*/
  vuint8_t CHCFG4;          /* offset: 0x00000004*/
  vuint8_t CHCFG5;          /* offset: 0x00000005*/
  vuint8_t CHCFG6;          /* offset: 0x00000006*/
  vuint8_t CHCFG7;          /* offset: 0x00000007*/
  vuint8_t CHCFG8;          /* offset: 0x00000008*/
  vuint8_t CHCFG9;          /* offset: 0x00000009*/
  vuint8_t CHCFG10;         /* offset: 0x0000000A*/
  vuint8_t CHCFG11;         /* offset: 0x0000000B*/
  vuint8_t CHCFG12;         /* offset: 0x0000000C*/
  vuint8_t CHCFG13;         /* offset: 0x0000000D*/
  vuint8_t CHCFG14;         /* offset: 0x0000000E*/
  vuint8_t CHCFG15;         /* offset: 0x0000000F*/
} volatile *DMAMUX_MemMapPtr;

struct DMAMUXx_tag {
        union {
            vuint8_t R;
            struct {
                vuint8_t SOURCE:6;
                vuint8_t TRIG:1;
                vuint8_t ENBL:1;
} B;
        } CHCONFIG[16];                 /* DMA Channel Configuration Register */

    };                                  /* end of DMAMUX_tag */



/* DMAMUX - Register offsets */
#define DMAMUX_CHCFG0_OFFSET         0x00000000
#define DMAMUX_CHCFG1_OFFSET         0x00000001
#define DMAMUX_CHCFG2_OFFSET         0x00000002
#define DMAMUX_CHCFG3_OFFSET         0x00000003
#define DMAMUX_CHCFG4_OFFSET         0x00000004
#define DMAMUX_CHCFG5_OFFSET         0x00000005
#define DMAMUX_CHCFG6_OFFSET         0x00000006
#define DMAMUX_CHCFG7_OFFSET         0x00000007
#define DMAMUX_CHCFG8_OFFSET         0x00000008
#define DMAMUX_CHCFG9_OFFSET         0x00000009
#define DMAMUX_CHCFG10_OFFSET        0x0000000A
#define DMAMUX_CHCFG11_OFFSET        0x0000000B
#define DMAMUX_CHCFG12_OFFSET        0x0000000C
#define DMAMUX_CHCFG13_OFFSET        0x0000000D
#define DMAMUX_CHCFG14_OFFSET        0x0000000E
#define DMAMUX_CHCFG15_OFFSET        0x0000000F

/* DMAMUX Register per module */
#define DMAMUX0_CHCFG0                (DMAMUX0_BASE + DMAMUX_CHCFG0_OFFSET)
#define DMAMUX0_CHCFG1                (DMAMUX0_BASE + DMAMUX_CHCFG1_OFFSET)
#define DMAMUX0_CHCFG2                (DMAMUX0_BASE + DMAMUX_CHCFG2_OFFSET)
#define DMAMUX0_CHCFG3                (DMAMUX0_BASE + DMAMUX_CHCFG3_OFFSET)
#define DMAMUX0_CHCFG4                (DMAMUX0_BASE + DMAMUX_CHCFG4_OFFSET)
#define DMAMUX0_CHCFG5                (DMAMUX0_BASE + DMAMUX_CHCFG5_OFFSET)
#define DMAMUX0_CHCFG6                (DMAMUX0_BASE + DMAMUX_CHCFG6_OFFSET)
#define DMAMUX0_CHCFG7                (DMAMUX0_BASE + DMAMUX_CHCFG7_OFFSET)
#define DMAMUX0_CHCFG8                (DMAMUX0_BASE + DMAMUX_CHCFG8_OFFSET)
#define DMAMUX0_CHCFG9                (DMAMUX0_BASE + DMAMUX_CHCFG9_OFFSET)
#define DMAMUX0_CHCFG10               (DMAMUX0_BASE + DMAMUX_CHCFG10_OFFSET)
#define DMAMUX0_CHCFG11               (DMAMUX0_BASE + DMAMUX_CHCFG11_OFFSET)
#define DMAMUX0_CHCFG12               (DMAMUX0_BASE + DMAMUX_CHCFG12_OFFSET)
#define DMAMUX0_CHCFG13               (DMAMUX0_BASE + DMAMUX_CHCFG13_OFFSET)
#define DMAMUX0_CHCFG14               (DMAMUX0_BASE + DMAMUX_CHCFG14_OFFSET)
#define DMAMUX0_CHCFG15               (DMAMUX0_BASE + DMAMUX_CHCFG15_OFFSET)

#define DMAMUX1_CHCFG0                (DMAMUX1_BASE + DMAMUX_CHCFG0_OFFSET)
#define DMAMUX1_CHCFG1                (DMAMUX1_BASE + DMAMUX_CHCFG1_OFFSET)
#define DMAMUX1_CHCFG2                (DMAMUX1_BASE + DMAMUX_CHCFG2_OFFSET)
#define DMAMUX1_CHCFG3                (DMAMUX1_BASE + DMAMUX_CHCFG3_OFFSET)
#define DMAMUX1_CHCFG4                (DMAMUX1_BASE + DMAMUX_CHCFG4_OFFSET)
#define DMAMUX1_CHCFG5                (DMAMUX1_BASE + DMAMUX_CHCFG5_OFFSET)
#define DMAMUX1_CHCFG6                (DMAMUX1_BASE + DMAMUX_CHCFG6_OFFSET)
#define DMAMUX1_CHCFG7                (DMAMUX1_BASE + DMAMUX_CHCFG7_OFFSET)
#define DMAMUX1_CHCFG8                (DMAMUX1_BASE + DMAMUX_CHCFG8_OFFSET)
#define DMAMUX1_CHCFG9                (DMAMUX1_BASE + DMAMUX_CHCFG9_OFFSET)
#define DMAMUX1_CHCFG10               (DMAMUX1_BASE + DMAMUX_CHCFG10_OFFSET)
#define DMAMUX1_CHCFG11               (DMAMUX1_BASE + DMAMUX_CHCFG11_OFFSET)
#define DMAMUX1_CHCFG12               (DMAMUX1_BASE + DMAMUX_CHCFG12_OFFSET)
#define DMAMUX1_CHCFG13               (DMAMUX1_BASE + DMAMUX_CHCFG13_OFFSET)
#define DMAMUX1_CHCFG14               (DMAMUX1_BASE + DMAMUX_CHCFG14_OFFSET)
#define DMAMUX1_CHCFG15               (DMAMUX1_BASE + DMAMUX_CHCFG15_OFFSET)

#define DMAMUX2_CHCFG0                (DMAMUX2_BASE + DMAMUX_CHCFG0_OFFSET)
#define DMAMUX2_CHCFG1                (DMAMUX2_BASE + DMAMUX_CHCFG1_OFFSET)
#define DMAMUX2_CHCFG2                (DMAMUX2_BASE + DMAMUX_CHCFG2_OFFSET)
#define DMAMUX2_CHCFG3                (DMAMUX2_BASE + DMAMUX_CHCFG3_OFFSET)
#define DMAMUX2_CHCFG4                (DMAMUX2_BASE + DMAMUX_CHCFG4_OFFSET)
#define DMAMUX2_CHCFG5                (DMAMUX2_BASE + DMAMUX_CHCFG5_OFFSET)
#define DMAMUX2_CHCFG6                (DMAMUX2_BASE + DMAMUX_CHCFG6_OFFSET)
#define DMAMUX2_CHCFG7                (DMAMUX2_BASE + DMAMUX_CHCFG7_OFFSET)
#define DMAMUX2_CHCFG8                (DMAMUX2_BASE + DMAMUX_CHCFG8_OFFSET)
#define DMAMUX2_CHCFG9                (DMAMUX2_BASE + DMAMUX_CHCFG9_OFFSET)
#define DMAMUX2_CHCFG10               (DMAMUX2_BASE + DMAMUX_CHCFG10_OFFSET)
#define DMAMUX2_CHCFG11               (DMAMUX2_BASE + DMAMUX_CHCFG11_OFFSET)
#define DMAMUX2_CHCFG12               (DMAMUX2_BASE + DMAMUX_CHCFG12_OFFSET)
#define DMAMUX2_CHCFG13               (DMAMUX2_BASE + DMAMUX_CHCFG13_OFFSET)
#define DMAMUX2_CHCFG14               (DMAMUX2_BASE + DMAMUX_CHCFG14_OFFSET)
#define DMAMUX2_CHCFG15               (DMAMUX2_BASE + DMAMUX_CHCFG15_OFFSET)

#define DMAMUX3_CHCFG0                (DMAMUX3_BASE + DMAMUX_CHCFG0_OFFSET)
#define DMAMUX3_CHCFG1                (DMAMUX3_BASE + DMAMUX_CHCFG1_OFFSET)
#define DMAMUX3_CHCFG2                (DMAMUX3_BASE + DMAMUX_CHCFG2_OFFSET)
#define DMAMUX3_CHCFG3                (DMAMUX3_BASE + DMAMUX_CHCFG3_OFFSET)
#define DMAMUX3_CHCFG4                (DMAMUX3_BASE + DMAMUX_CHCFG4_OFFSET)
#define DMAMUX3_CHCFG5                (DMAMUX3_BASE + DMAMUX_CHCFG5_OFFSET)
#define DMAMUX3_CHCFG6                (DMAMUX3_BASE + DMAMUX_CHCFG6_OFFSET)
#define DMAMUX3_CHCFG7                (DMAMUX3_BASE + DMAMUX_CHCFG7_OFFSET)
#define DMAMUX3_CHCFG8                (DMAMUX3_BASE + DMAMUX_CHCFG8_OFFSET)
#define DMAMUX3_CHCFG9                (DMAMUX3_BASE + DMAMUX_CHCFG9_OFFSET)
#define DMAMUX3_CHCFG10               (DMAMUX3_BASE + DMAMUX_CHCFG10_OFFSET)
#define DMAMUX3_CHCFG11               (DMAMUX3_BASE + DMAMUX_CHCFG11_OFFSET)
#define DMAMUX3_CHCFG12               (DMAMUX3_BASE + DMAMUX_CHCFG12_OFFSET)
#define DMAMUX3_CHCFG13               (DMAMUX3_BASE + DMAMUX_CHCFG13_OFFSET)
#define DMAMUX3_CHCFG14               (DMAMUX3_BASE + DMAMUX_CHCFG14_OFFSET)
#define DMAMUX3_CHCFG15               (DMAMUX3_BASE + DMAMUX_CHCFG15_OFFSET)

/* Field definitions for CHCFGn */
#define DMAMUX_CHCFGn_SOURCE_SHIFT        (0)
#define DMAMUX_CHCFGn_SOURCE_MASK         ((0x3F) << (DMAMUX_CHCFGn_SOURCE_SHIFT)) 

#define DMAMUX_CHCFGn_TRIG_SHIFT          (6)  
#define DMAMUX_CHCFGn_TRIG_MASK           ((1) << (DMAMUX_CHCFGn_TRIG_SHIFT)) 

#define DMAMUX_CHCFGn_ENBL_SHIFT          (7)  
#define DMAMUX_CHCFGn_ENBL_MASK           ((1) << (DMAMUX_CHCFGn_ENBL_SHIFT)) 


/*** End of bit definitions ***/

/*** define base address ***/
#define DMAMUX0_BASE		0x40024000
#define DMAMUX1_BASE		0x40025000
#define DMAMUX2_BASE		0x400A1000
#define DMAMUX3_BASE		0x400A2000

#define DMAMUXx          (*(volatile struct DMAMUXx_tag *)    0x400A1000UL)

#endif
